function rx_passband = real_channel(input_file_name)

% Read the .wav file that was recorder at the receiver smart-phopne
rx_passband = audioread(input_file_name, 'double');

% The received signal might have small values. Normalize it, that's also
% what we did before writing it into a .wav file at the transmitter side
rx_passband = rx_passband / max(abs(rx_passband));

% It was recorded as stereo. Both stream are similar though, so just pick
% one
rx_passband = rx_passband(:,1);

% Here we can plot the power spectrum of the received signal

pwelch(rx_passband);

end